/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidplay.common.VideoCoderPreset;
import libsidplay.config.IAudioSection;
import sidplay.audio.Audio;
import sidplay.ini.IniDefaults;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;
import sidplay.ini.converter.BeanToStringConverter;

@Parameters(resourceBundle="sidplay.ini.IniAudioSection")
public class IniAudioSection
extends IniSection
implements IAudioSection {
    private static final String SECTION_ID = "Audio";

    public IniAudioSection(IniReader iniReader) {
        super(iniReader);
    }

    @Override
    public final Audio getAudio() {
        return this.iniReader.getPropertyEnum(SECTION_ID, SECTION_ID, IniDefaults.DEFAULT_AUDIO, Audio.class);
    }

    @Override
    @Parameter(names={"--audio", "-a"}, descriptionKey="DRIVER", order=100)
    public final void setAudio(Audio audio) {
        this.iniReader.setProperty(SECTION_ID, SECTION_ID, (Object)audio);
    }

    @Override
    public final int getDevice() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Device", IniDefaults.DEFAULT_DEVICE);
    }

    @Override
    @Parameter(names={"--deviceIndex", "-A"}, descriptionKey="DEVICEINDEX", order=101)
    public final void setDevice(int device) {
        this.iniReader.setProperty(SECTION_ID, "Device", device);
    }

    @Override
    public final SamplingRate getSamplingRate() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "Sampling Rate", IniDefaults.DEFAULT_SAMPLING_RATE, SamplingRate.class);
    }

    @Override
    @Parameter(names={"--frequency", "-f", "--samplingRate"}, descriptionKey="FREQUENCY", order=102)
    public final void setSamplingRate(SamplingRate samplingRate) {
        this.iniReader.setProperty(SECTION_ID, "Sampling Rate", (Object)samplingRate);
    }

    @Override
    public final SamplingMethod getSampling() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "Sampling", IniDefaults.DEFAULT_SAMPLING, SamplingMethod.class);
    }

    @Override
    @Parameter(names={"--sampling"}, descriptionKey="SAMPLING", order=103)
    public final void setSampling(SamplingMethod method) {
        this.iniReader.setProperty(SECTION_ID, "Sampling", (Object)method);
    }

    @Override
    public final float getMainVolume() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "MainVolume", IniDefaults.DEFAULT_MAIN_VOLUME);
    }

    @Override
    @Parameter(names={"--mainVolume"}, descriptionKey="MAIN_VOLUME", order=104)
    public final void setMainVolume(float volume) {
        this.iniReader.setProperty(SECTION_ID, "MainVolume", Float.valueOf(volume));
    }

    @Override
    public final float getSecondVolume() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "SecondVolume", IniDefaults.DEFAULT_SECOND_VOLUME);
    }

    @Override
    @Parameter(names={"--secondVolume"}, descriptionKey="SECOND_VOLUME", order=105)
    public final void setSecondVolume(float volume) {
        this.iniReader.setProperty(SECTION_ID, "SecondVolume", Float.valueOf(volume));
    }

    @Override
    public final float getThirdVolume() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "ThirdVolume", IniDefaults.DEFAULT_THIRD_VOLUME);
    }

    @Override
    @Parameter(names={"--thirdVolume"}, descriptionKey="THIRD_VOLUME", order=106)
    public final void setThirdVolume(float volume) {
        this.iniReader.setProperty(SECTION_ID, "ThirdVolume", Float.valueOf(volume));
    }

    @Override
    public final float getMainBalance() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "MainBalance", IniDefaults.DEFAULT_MAIN_BALANCE);
    }

    @Override
    @Parameter(names={"--mainBalance"}, descriptionKey="MAIN_BALANCE", order=107)
    public final void setMainBalance(float balance) {
        this.iniReader.setProperty(SECTION_ID, "MainBalance", Float.valueOf(balance));
    }

    @Override
    public final float getSecondBalance() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "SecondBalance", IniDefaults.DEFAULT_SECOND_BALANCE);
    }

    @Override
    @Parameter(names={"--secondBalance"}, descriptionKey="SECOND_BALANCE", order=108)
    public final void setSecondBalance(float balance) {
        this.iniReader.setProperty(SECTION_ID, "SecondBalance", Float.valueOf(balance));
    }

    @Override
    public final float getThirdBalance() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "ThirdBalance", IniDefaults.DEFAULT_THIRD_BALANCE);
    }

    @Override
    @Parameter(names={"--thirdBalance"}, descriptionKey="THIRD_BALANCE", order=109)
    public final void setThirdBalance(float balance) {
        this.iniReader.setProperty(SECTION_ID, "ThirdBalance", Float.valueOf(balance));
    }

    @Override
    public final int getMainDelay() {
        return this.iniReader.getPropertyInt(SECTION_ID, "MainDelay", IniDefaults.DEFAULT_MAIN_DELAY);
    }

    @Override
    @Parameter(names={"--mainDelay"}, descriptionKey="MAIN_DELAY", order=110)
    public final void setMainDelay(int delay) {
        this.iniReader.setProperty(SECTION_ID, "MainDelay", delay);
    }

    @Override
    public final int getSecondDelay() {
        return this.iniReader.getPropertyInt(SECTION_ID, "SecondDelay", IniDefaults.DEFAULT_SECOND_DELAY);
    }

    @Override
    @Parameter(names={"--secondDelay"}, descriptionKey="SECOND_DELAY", order=111)
    public final void setSecondDelay(int delay) {
        this.iniReader.setProperty(SECTION_ID, "SecondDelay", delay);
    }

    @Override
    public final int getThirdDelay() {
        return this.iniReader.getPropertyInt(SECTION_ID, "ThirdDelay", IniDefaults.DEFAULT_THIRD_DELAY);
    }

    @Override
    @Parameter(names={"--thirdDelay"}, descriptionKey="THIRD_DELAY", order=112)
    public final void setThirdDelay(int delay) {
        this.iniReader.setProperty(SECTION_ID, "ThirdDelay", delay);
    }

    @Override
    public final int getBufferSize() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Buffer Size", IniDefaults.DEFAULT_BUFFER_SIZE);
    }

    @Override
    @Parameter(names={"--bufferSize", "-B"}, descriptionKey="BUFFER_SIZE", order=113)
    public final void setBufferSize(int bufferSize) {
        this.iniReader.setProperty(SECTION_ID, "Buffer Size", bufferSize);
    }

    @Override
    public final int getAudioBufferSize() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Audio Buffer Size", IniDefaults.DEFAULT_AUDIO_BUFFER_SIZE);
    }

    @Override
    @Parameter(names={"--audioBufferSize"}, descriptionKey="AUDIO_BUFFER_SIZE", order=114)
    public final void setAudioBufferSize(int audioBufferSize) {
        this.iniReader.setProperty(SECTION_ID, "Audio Buffer Size", audioBufferSize);
    }

    @Override
    public final int getCbr() {
        return this.iniReader.getPropertyInt(SECTION_ID, "MP3 CBR", IniDefaults.DEFAULT_CBR);
    }

    @Override
    @Parameter(names={"--cbr"}, descriptionKey="CBR", order=115)
    public final void setCbr(int cbr) {
        this.iniReader.setProperty(SECTION_ID, "MP3 CBR", cbr);
    }

    @Override
    public final boolean isVbr() {
        return this.iniReader.getPropertyBool(SECTION_ID, "MP3 VBR", IniDefaults.DEFAULT_VBR);
    }

    @Override
    @Parameter(names={"--vbr"}, descriptionKey="VBR", arity=1, order=116)
    public final void setVbr(boolean vbr) {
        this.iniReader.setProperty(SECTION_ID, "MP3 VBR", vbr);
    }

    @Override
    public final int getVbrQuality() {
        return this.iniReader.getPropertyInt(SECTION_ID, "MP3 VBR Quality", IniDefaults.DEFAULT_VBR_QUALITY);
    }

    @Override
    @Parameter(names={"--vbrQuality"}, descriptionKey="VBR_QUALITY", order=117)
    public final void setVbrQuality(int vbr) {
        this.iniReader.setProperty(SECTION_ID, "MP3 VBR Quality", vbr);
    }

    @Override
    public final int getAudioCoderBitRate() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Audio Coder Bit Rate", IniDefaults.DEFAULT_AUDIO_CODER_BIT_RATE);
    }

    @Override
    @Parameter(names={"--acBitRate", "--audioCoderBitRate"}, descriptionKey="AUDIO_CODER_BIT_RATE", order=118)
    public final void setAudioCoderBitRate(int bitRate) {
        this.iniReader.setProperty(SECTION_ID, "Audio Coder Bit Rate", bitRate);
    }

    @Override
    public final int getAudioCoderBitRateTolerance() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Audio Coder Bit Rate Tolerance", IniDefaults.DEFAULT_AUDIO_CODER_BIT_RATE_TOLERANCE);
    }

    @Override
    @Parameter(names={"--acBitRateTolerance", "--audioCoderBitRateTolerance"}, descriptionKey="AUDIO_CODER_BIT_RATE_TOLERANCE", order=119)
    public final void setAudioCoderBitRateTolerance(int bitRateTolerance) {
        this.iniReader.setProperty(SECTION_ID, "Audio Coder Bit Rate Tolerance", bitRateTolerance);
    }

    @Override
    public final String getVideoStreamingUrl() {
        return this.iniReader.getPropertyString(SECTION_ID, "Video Streaming URL", IniDefaults.DEFAULT_VIDEO_STREAMING_URL);
    }

    @Override
    @Parameter(names={"--vcStreamingUrl"}, descriptionKey="VIDEO_CODER_STREAMING_URL", order=120)
    public final void setVideoStreamingUrl(String videoStreamingUrl) {
        this.iniReader.setProperty(SECTION_ID, "Video Streaming URL", videoStreamingUrl);
    }

    @Override
    public final int getVideoCoderNumPicturesInGroupOfPictures() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Video Coder GOP", IniDefaults.DEFAULT_VIDEO_CODER_GOP);
    }

    @Override
    @Parameter(names={"--vcGOP", "--videoCoderNumPicturesInGroupOfPictures"}, descriptionKey="VIDEO_CODER_GOP", order=121)
    public final void setVideoCoderNumPicturesInGroupOfPictures(int numPicturesInGroupOfPictures) {
        this.iniReader.setProperty(SECTION_ID, "Video Coder GOP", numPicturesInGroupOfPictures);
    }

    @Override
    public final int getVideoCoderBitRate() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Video Coder Bit Rate", IniDefaults.DEFAULT_VIDEO_CODER_BIT_RATE);
    }

    @Override
    @Parameter(names={"--vcBitRate", "--videoCoderBitRate"}, descriptionKey="VIDEO_CODER_BIT_RATE", order=122)
    public final void setVideoCoderBitRate(int bitRate) {
        this.iniReader.setProperty(SECTION_ID, "Video Coder Bit Rate", bitRate);
    }

    @Override
    public final int getVideoCoderBitRateTolerance() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Video Coder Bit Rate Tolerance", IniDefaults.DEFAULT_VIDEO_CODER_BIT_RATE_TOLERANCE);
    }

    @Override
    @Parameter(names={"--vcBitRateTolerance", "--videoCoderBitRateTolerance"}, descriptionKey="VIDEO_CODER_BIT_RATE_TOLERANCE", order=123)
    public final void setVideoCoderBitRateTolerance(int bitRateTolerance) {
        this.iniReader.setProperty(SECTION_ID, "Video Coder Bit Rate Tolerance", bitRateTolerance);
    }

    @Override
    public final int getVideoCoderGlobalQuality() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Video Coder Global Quality", IniDefaults.DEFAULT_VIDEO_CODER_GLOBAL_QUALITY);
    }

    @Override
    @Parameter(names={"--vcGlobalQuality", "--videoCoderGlobalQuality"}, descriptionKey="VIDEO_CODER_GLOBAL_QUALITY", order=124)
    public final void setVideoCoderGlobalQuality(int globalQuality) {
        this.iniReader.setProperty(SECTION_ID, "Video Coder Global Quality", globalQuality);
    }

    @Override
    public final VideoCoderPreset getVideoCoderPreset() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "Video Coder Preset", IniDefaults.DEFAULT_VIDEO_CODER_PRESET, VideoCoderPreset.class);
    }

    @Override
    @Parameter(names={"--vcPreset", "--videoCoderPreset"}, descriptionKey="VIDEO_CODER_PRESET", order=125)
    public final void setVideoCoderPreset(VideoCoderPreset preset) {
        this.iniReader.setProperty(SECTION_ID, "Video Coder Preset", (Object)preset);
    }

    @Override
    public final int getVideoCoderAudioDelay() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Video Coder Audio Delay", IniDefaults.DEFAULT_VIDEO_CODER_AUDIO_DELAY);
    }

    @Override
    @Parameter(names={"--vcAudioDelay", "--videoCoderAudioDelay"}, descriptionKey="VIDEO_CODER_AUDIO_DELAY", order=126)
    public final void setVideoCoderAudioDelay(int audioDelay) {
        this.iniReader.setProperty(SECTION_ID, "Video Coder Audio Delay", audioDelay);
    }

    @Override
    public final boolean isPlayOriginal() {
        return this.iniReader.getPropertyBool(SECTION_ID, "Play Original", IniDefaults.DEFAULT_PLAY_ORIGINAL);
    }

    @Override
    public final void setPlayOriginal(boolean original) {
        this.iniReader.setProperty(SECTION_ID, "Play Original", original);
    }

    @Override
    public final File getMp3() {
        return this.iniReader.getPropertyFile(SECTION_ID, "MP3 File", IniDefaults.DEFAULT_MP3_FILE);
    }

    @Override
    public final void setMp3(File recording) {
        this.iniReader.setProperty(SECTION_ID, "MP3 File", recording);
    }

    @Override
    public final boolean getDelayBypass() {
        return this.iniReader.getPropertyBool(SECTION_ID, "Delay Bypass", IniDefaults.DEFAULT_DELAY_BYPASS);
    }

    @Override
    @Parameter(names={"--delayBypass"}, descriptionKey="DELAY_BYPASS", arity=1, order=127)
    public final void setDelayBypass(boolean delayBypass) {
        this.iniReader.setProperty(SECTION_ID, "Delay Bypass", delayBypass);
    }

    @Override
    public final int getDelay() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Delay", IniDefaults.DEFAULT_DELAY);
    }

    @Override
    @Parameter(names={"--delay"}, descriptionKey="DELAY", order=128)
    public final void setDelay(int delay) {
        this.iniReader.setProperty(SECTION_ID, "Delay", delay);
    }

    @Override
    public final int getDelayWetLevel() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Delay Wet Level", IniDefaults.DEFAULT_DELAY_WET_LEVEL);
    }

    @Override
    @Parameter(names={"--delayWetLevel"}, descriptionKey="DELAY_WET_LEVEL", order=129)
    public final void setDelayWetLevel(int delayWetLevel) {
        this.iniReader.setProperty(SECTION_ID, "Delay Wet Level", delayWetLevel);
    }

    @Override
    public final int getDelayDryLevel() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Delay Dry Level", IniDefaults.DEFAULT_DELAY_DRY_LEVEL);
    }

    @Override
    @Parameter(names={"--delayDryLevel"}, descriptionKey="DELAY_DRY_LEVEL", order=130)
    public final void setDelayDryLevel(int delayDryLevel) {
        this.iniReader.setProperty(SECTION_ID, "Delay Dry Level", delayDryLevel);
    }

    @Override
    public final int getDelayFeedbackLevel() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Delay Feedback Level", IniDefaults.DEFAULT_DELAY_FEEDBACK_LEVEL);
    }

    @Override
    @Parameter(names={"--delayFeedbackLevel"}, descriptionKey="DELAY_FEEDBACK_LEVEL", order=131)
    public final void setDelayFeedbackLevel(int delayFeedbackLevel) {
        this.iniReader.setProperty(SECTION_ID, "Delay Feedback Level", delayFeedbackLevel);
    }

    @Override
    public final boolean getReverbBypass() {
        return this.iniReader.getPropertyBool(SECTION_ID, "Reverb Bypass", IniDefaults.DEFAULT_REVERB_BYPASS);
    }

    @Override
    @Parameter(names={"--reverbBypass"}, descriptionKey="REVERB_BYPASS", arity=1, order=132)
    public final void setReverbBypass(boolean reverbBypass) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Bypass", reverbBypass);
    }

    @Override
    public final float getReverbComb1Delay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb Comb1 Delay", IniDefaults.DEFAULT_REVERB_COMB1_DELAY);
    }

    @Override
    @Parameter(names={"--reverbComb1Delay"}, descriptionKey="REVERB_COMB1_DELAY", order=133)
    public final void setReverbComb1Delay(float reverbComb1Delay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Comb1 Delay", Float.valueOf(reverbComb1Delay));
    }

    @Override
    public final float getReverbComb2Delay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb Comb2 Delay", IniDefaults.DEFAULT_REVERB_COMB2_DELAY);
    }

    @Override
    @Parameter(names={"--reverbComb2Delay"}, descriptionKey="REVERB_COMB2_DELAY", order=134)
    public final void setReverbComb2Delay(float reverbComb2Delay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Comb2 Delay", Float.valueOf(reverbComb2Delay));
    }

    @Override
    public final float getReverbComb3Delay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb Comb3 Delay", IniDefaults.DEFAULT_REVERB_COMB3_DELAY);
    }

    @Override
    @Parameter(names={"--reverbComb3Delay"}, descriptionKey="REVERB_COMB3_DELAY", order=135)
    public final void setReverbComb3Delay(float reverbComb3Delay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Comb3 Delay", Float.valueOf(reverbComb3Delay));
    }

    @Override
    public final float getReverbComb4Delay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb Comb4 Delay", IniDefaults.DEFAULT_REVERB_COMB4_DELAY);
    }

    @Override
    @Parameter(names={"--reverbComb4Delay"}, descriptionKey="REVERB_COMB4_DELAY", order=136)
    public final void setReverbComb4Delay(float reverbComb4Delay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Comb4 Delay", Float.valueOf(reverbComb4Delay));
    }

    @Override
    public final float getReverbAllPass1Delay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb All Pass1 Delay", IniDefaults.DEFAULT_REVERB_COMB1_DELAY);
    }

    @Override
    @Parameter(names={"--reverbAllPass1Delay"}, descriptionKey="REVERB_ALL_PASS1_DELAY", order=137)
    public final void setReverbAllPass1Delay(float reverbAllPass1Delay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb All Pass1 Delay", Float.valueOf(reverbAllPass1Delay));
    }

    @Override
    public final float getReverbAllPass2Delay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb All Pass2 Delay", IniDefaults.DEFAULT_REVERB_COMB2_DELAY);
    }

    @Override
    @Parameter(names={"--reverbAllPass2Delay"}, descriptionKey="REVERB_ALL_PASS2_DELAY", order=138)
    public final void setReverbAllPass2Delay(float reverbAllPass2Delay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb All Pass2 Delay", Float.valueOf(reverbAllPass2Delay));
    }

    @Override
    public final float getReverbSustainDelay() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb Sustain Delay", IniDefaults.DEFAULT_REVERB_SUSTAIN_DELAY);
    }

    @Override
    @Parameter(names={"--reverbSustainDelay"}, descriptionKey="REVERB_SUSTAIN_DELAY", order=139)
    public final void setReverbSustainDelay(float reverbSustainDelay) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Sustain Delay", Float.valueOf(reverbSustainDelay));
    }

    @Override
    public final float getReverbDryWetMix() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Reverb Dry Wet Mix", IniDefaults.DEFAULT_REVERB_DRY_WET_MIX);
    }

    @Override
    @Parameter(names={"--reverbDryWetMix"}, descriptionKey="REVERB_DRY_WET_MIX", order=140)
    public final void setReverbDryWetMix(float reverbDryWetMix) {
        this.iniReader.setProperty(SECTION_ID, "Reverb Dry Wet Mix", Float.valueOf(reverbDryWetMix));
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

